#!/bin/bash
# generate_cert_updated.sh

echo "Generating SSL certificate..."

# 生成RSA私钥
openssl genrsa -out server.key 2048

# 生成证书配置
cat > server.cnf << EOF
[req]
distinguished_name = req_distinguished_name
x509_extensions = v3_req
prompt = no

[req_distinguished_name]
C = US
ST = State
L = City
O = Organization
OU = Organizational Unit
CN = localhost

[v3_req]
keyUsage = critical, digitalSignature, keyEncipherment
extendedKeyUsage = serverAuth, clientAuth
subjectAltName = @alt_names

[alt_names]
DNS.1 = localhost
DNS.2 = 127.0.0.1
IP.1 = 127.0.0.1
EOF

# 生成自签名证书（包含SAN扩展）
openssl req -new -x509 -key server.key -out server.crt -days 3650 -config server.cnf

# 验证证书
echo "Certificate details:"
openssl x509 -in server.crt -text -noout | grep -E "Subject:|DNS:|IP Address:"

# 设置权限
chmod 600 server.key
chmod 644 server.crt

echo "Certificate files generated: server.key, server.crt"


